package w83a.w83aBeans;

import java.sql.ResultSet;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Date;

import w83a.w83aDAO.w83aConstantesBD.W83aBaseBeanBD;
import w83a.util.jdbc.W83aDataBase;
import w83a.w83aDAO.w83aConstantesBD.W83aPreavisosBD;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aDateUtil;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bHistorialPreavisoBean.
 */
public class W83aHistorialPreavisoBean extends W83aBaseBean implements W83aBaseBeanBD{
	
	/** The Constant serialVersionUID. */
	private static final long	serialVersionUID	= 1L;

	/** The fecha_actuacion. */
	private Date fecha_actuacion;
	
	/** The dia_actuacion. */
	private String dia_actuacion;
	
	/** The hora_actuacion. */
	private String hora_actuacion;
	
	/** The descripcion. */
	private String descripcion;
	
	/** The usuario. */
	private String usuario;
	
	/**
	 * Gets the fecha_actuacion.
	 * 
	 * @return the fecha_actuacion
	 */
	public Date getFecha_actuacion() {
		return this.fecha_actuacion;
	}
	
	/**
	 * Sets the fecha_actuacion.
	 * 
	 * @param fecha_actuacion the new fecha_actuacion
	 */
	public void setFecha_actuacion(Date fecha_actuacion) {
		this.fecha_actuacion = fecha_actuacion;
	}
	
	/**
	 * Gets the dia_actuacion.
	 * 
	 * @return the dia_actuacion
	 */
	public String getDia_actuacion() {
		return this.dia_actuacion;
	}
	
	/**
	 * Sets the dia_actuacion.
	 * 
	 * @param dia_actuacion the new dia_actuacion
	 */
	public void setDia_actuacion(String dia_actuacion) {
		this.dia_actuacion = dia_actuacion;
	}
	
	/**
	 * Gets the hora_actuacion.
	 * 
	 * @return the hora_actuacion
	 */
	public String getHora_actuacion() {
		return this.hora_actuacion;
	}
	
	/**
	 * Sets the hora_actuacion.
	 * 
	 * @param hora_actuacion the new hora_actuacion
	 */
	public void setHora_actuacion(String hora_actuacion) {
		this.hora_actuacion = hora_actuacion;
	}
	
	/**
	 * Gets the descripcion.
	 * 
	 * @return the descripcion
	 */
	public String getDescripcion() {
		return this.descripcion;
	}
	
	/**
	 * Sets the descripcion.
	 * 
	 * @param descripcion the new descripcion
	 */
	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}
	
	/**
	 * Gets the usuario.
	 * 
	 * @return the usuario
	 */
	public String getUsuario() {
		return this.usuario;
	}
	
	/**
	 * Sets the usuario.
	 * 
	 * @param usuario the new usuario
	 */
	public void setUsuario(String usuario) {
		this.usuario = usuario;
	}
	
	/**
	 * Row to bean.
	 * 
	 * @param o the o
	 * @param otrosValores the otros valores
	 * @return the object
	 * @throws Exception the exception
	 */
	public Object rowToBean(Object o, Object otrosValores) throws Exception {
		ResultSet rs = (ResultSet)o;//NOPMD
		String formato = "";
		
		if(null!=otrosValores && otrosValores instanceof String && W83aClsConstantes.CONSTANTE_CASTELLANO.equals(otrosValores)){
			formato = W83aDateUtil.getInstance().devolverFormatoIdioma(W83aClsConstantes.CONSTANTE_CASTELLANO);
		}else if(null!=otrosValores && otrosValores instanceof String && W83aClsConstantes.CONSTANTE_EUSKARA.equals(otrosValores)){
			formato = W83aDateUtil.getInstance().devolverFormatoIdioma(W83aClsConstantes.CONSTANTE_EUSKARA);			
		}
		
		if (W83aDataBase.getDateFromRS(rs, W83aPreavisosBD.factu_055)!=null)
		{
			this.fecha_actuacion=W83aDataBase.getDateFromRS(rs, W83aPreavisosBD.factu_055);
			this.dia_actuacion=new SimpleDateFormat(formato).format(this.fecha_actuacion);
			Time hora=rs.getTime(W83aPreavisosBD.factu_055);
			
			this.hora_actuacion=hora.toString();
		}
		this.descripcion=W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.descripcion);
		this.usuario=W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.usua_055);
		
		return this;
	}
	
	
}
